<?php
require_login();

$doc_id = (int)($_GET['doc_id'] ?? 0);
if (!$doc_id) { http_response_code(400); echo "Missing doc_id"; exit; }

// find doc + matter
$stmt = $db->prepare("SELECT d.id, d.matter_id, d.latest_version, d.title
                      FROM documents d WHERE d.id=?");
$stmt->execute([$doc_id]);
$d = $stmt->fetch();
if (!$d) { http_response_code(404); echo "Document not found"; exit; }

$matter_id = (int)$d['matter_id'];
if (!can_access_matter($db, $matter_id)) { http_response_code(403); echo "Access denied."; exit; }

$ver = (int)($_GET['v'] ?? $d['latest_version']);
$stmt = $db->prepare("SELECT * FROM document_versions WHERE document_id=? AND version_no=?");
$stmt->execute([$doc_id, $ver]);
$v = $stmt->fetch();
if (!$v) { http_response_code(404); echo "Version not found"; exit; }

$path = $v['storage_path'];
if (!is_file($path)) { http_response_code(404); echo "File missing"; exit; }

audit($db, 'doc_download', $matter_id, "Downloaded doc #$doc_id v$ver");

$filename = $v['original_name'] ?: ($d['title'] . "_v" . $ver);
$mime = $v['mime_type'] ?: 'application/octet-stream';

header('Content-Description: File Transfer');
header('Content-Type: ' . $mime);
header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
header('Content-Length: ' . filesize($path));
header('X-Content-Type-Options: nosniff');

readfile($path);
exit;
