<?php
require_login();

$u = current_user();

// quick stats
$clients = (int)$db->query("SELECT COUNT(*) FROM clients")->fetchColumn();
$matters = (int)$db->query("SELECT COUNT(*) FROM matters")->fetchColumn();
$docs    = (int)$db->query("SELECT COUNT(*) FROM documents")->fetchColumn();

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="flex items-center justify-between mb-6">
  <div>
    <h1 class="text-2xl font-semibold">Dashboard</h1>
    <p class="text-slate-600">Welcome back, <?= e($u['full_name'] ?: $u['email']) ?>.</p>
  </div>
  <div class="flex gap-2">
    <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=matter_new">+ New Matter</a>
    <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php?r=client_new">+ New Client</a>
  </div>
</div>

<div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-8">
  <div class="bg-white border rounded-2xl p-4">
    <div class="text-sm text-slate-500">Clients</div>
    <div class="text-3xl font-semibold"><?= $clients ?></div>
  </div>
  <div class="bg-white border rounded-2xl p-4">
    <div class="text-sm text-slate-500">Matters</div>
    <div class="text-3xl font-semibold"><?= $matters ?></div>
  </div>
  <div class="bg-white border rounded-2xl p-4">
    <div class="text-sm text-slate-500">Documents</div>
    <div class="text-3xl font-semibold"><?= $docs ?></div>
  </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
  <div class="bg-white border rounded-2xl p-4">
    <div class="flex items-center justify-between mb-3">
      <h2 class="font-semibold">Recent matters</h2>
      <a class="text-sm underline" href="index.php?r=matters">View all</a>
    </div>
    <div class="space-y-2">
      <?php
        $sql = "SELECT m.id, m.ref_no, m.title, m.status, c.name AS client_name
                FROM matters m JOIN clients c ON c.id=m.client_id
                ORDER BY m.created_at DESC LIMIT 8";
        foreach ($db->query($sql) as $m):
      ?>
      <a href="index.php?r=matter_view&id=<?= (int)$m['id'] ?>" class="block p-3 rounded-xl border hover:bg-slate-50">
        <div class="flex items-center justify-between">
          <div class="font-medium"><?= e($m['ref_no']) ?> • <?= e($m['title']) ?></div>
          <div class="text-xs px-2 py-1 rounded-full bg-slate-100"><?= e($m['status']) ?></div>
        </div>
        <div class="text-sm text-slate-600"><?= e($m['client_name']) ?></div>
      </a>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="bg-white border rounded-2xl p-4">
    <div class="flex items-center justify-between mb-3">
      <h2 class="font-semibold">Recent activity</h2>
      <a class="text-sm underline" href="index.php?r=audit">Audit</a>
    </div>
    <div class="divide-y">
      <?php
        $stmt = $db->query("SELECT al.created_at, al.action, al.details, u.email
                            FROM audit_logs al LEFT JOIN users u ON u.id=al.user_id
                            ORDER BY al.id DESC LIMIT 12");
        foreach ($stmt as $row):
      ?>
      <div class="py-2">
        <div class="text-sm"><span class="font-medium"><?= e($row['action']) ?></span> <span class="text-slate-600"><?= e($row['details']) ?></span></div>
        <div class="text-xs text-slate-500"><?= e($row['created_at']) ?> • <?= e($row['email'] ?? 'system') ?></div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
