<?php
require_login();

if (!is_admin()) { http_response_code(403); echo "Admin only."; exit; }

$limit = 200;
$stmt = $db->prepare("SELECT al.*, u.email 
                      FROM audit_logs al LEFT JOIN users u ON u.id=al.user_id
                      ORDER BY al.id DESC LIMIT $limit");
$stmt->execute();

include __DIR__ . '/../app/views/partials/header.php';
?>
<div class="flex items-center justify-between mb-5">
  <div>
    <h1 class="text-2xl font-semibold">Audit log</h1>
    <p class="text-slate-600">Last <?= (int)$limit ?> actions (append-only).</p>
  </div>
  <a class="px-3 py-2 rounded-lg border bg-white hover:bg-slate-50" href="index.php">Back</a>
</div>

<div class="bg-white border rounded-2xl overflow-hidden">
  <table class="w-full text-sm">
    <thead class="bg-slate-50 text-slate-600">
      <tr>
        <th class="text-left p-3">Time</th>
        <th class="text-left p-3">User</th>
        <th class="text-left p-3">Action</th>
        <th class="text-left p-3">Matter</th>
        <th class="text-left p-3">Details</th>
        <th class="text-left p-3">IP</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($stmt as $row): ?>
      <tr class="border-t">
        <td class="p-3 whitespace-nowrap"><?= e($row['created_at']) ?></td>
        <td class="p-3"><?= e($row['email'] ?? 'system') ?></td>
        <td class="p-3 font-medium"><?= e($row['action']) ?></td>
        <td class="p-3"><?= e((string)($row['matter_id'] ?? '')) ?></td>
        <td class="p-3"><?= e($row['details'] ?? '') ?></td>
        <td class="p-3"><?= e($row['ip_address'] ?? '') ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
