<?php
require __DIR__ . '/app/bootstrap.php';

echo "<pre>";

function ok($m){ echo "[OK] $m\n"; }
function err($m){ echo "[ERR] $m\n"; }

try {
  $db->beginTransaction();

  $sql = [];

  $sql[] = "CREATE TABLE IF NOT EXISTS roles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(30) UNIQUE NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    role_id INT NOT NULL,
    full_name VARCHAR(120) NULL,
    email VARCHAR(190) UNIQUE NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL,
    updated_at DATETIME NOT NULL,
    FOREIGN KEY (role_id) REFERENCES roles(id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS clients (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(190) NOT NULL,
    email VARCHAR(190) NULL,
    phone VARCHAR(60) NULL,
    address TEXT NULL,
    created_at DATETIME NOT NULL,
    updated_at DATETIME NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS matters (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_id INT NOT NULL,
    ref_no VARCHAR(80) NOT NULL,
    title VARCHAR(255) NOT NULL,
    status VARCHAR(30) NOT NULL DEFAULT 'open',
    description TEXT NULL,
    created_at DATETIME NOT NULL,
    updated_at DATETIME NOT NULL,
    UNIQUE KEY uniq_client_ref (client_id, ref_no),
    FOREIGN KEY (client_id) REFERENCES clients(id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS matter_users (
    matter_id INT NOT NULL,
    user_id INT NOT NULL,
    created_at DATETIME NOT NULL,
    PRIMARY KEY (matter_id, user_id),
    FOREIGN KEY (matter_id) REFERENCES matters(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS folders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    matter_id INT NOT NULL,
    name VARCHAR(80) NOT NULL,
    created_at DATETIME NOT NULL,
    UNIQUE KEY uniq_matter_folder (matter_id, name),
    FOREIGN KEY (matter_id) REFERENCES matters(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS documents (
    id INT AUTO_INCREMENT PRIMARY KEY,
    matter_id INT NOT NULL,
    folder_id INT NOT NULL,
    title VARCHAR(190) NOT NULL,
    original_name VARCHAR(255) NULL,
    mime_type VARCHAR(120) NULL,
    latest_version INT NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL,
    updated_at DATETIME NOT NULL,
    INDEX idx_matter (matter_id),
    FOREIGN KEY (matter_id) REFERENCES matters(id) ON DELETE CASCADE,
    FOREIGN KEY (folder_id) REFERENCES folders(id) ON DELETE CASCADE
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS document_versions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    document_id INT NOT NULL,
    version_no INT NOT NULL,
    storage_path TEXT NOT NULL,
    original_name VARCHAR(255) NULL,
    mime_type VARCHAR(120) NULL,
    file_size BIGINT NULL,
    uploaded_by INT NULL,
    uploaded_at DATETIME NOT NULL,
    UNIQUE KEY uniq_doc_ver (document_id, version_no),
    FOREIGN KEY (document_id) REFERENCES documents(id) ON DELETE CASCADE,
    FOREIGN KEY (uploaded_by) REFERENCES users(id) ON DELETE SET NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  $sql[] = "CREATE TABLE IF NOT EXISTS audit_logs (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NULL,
    action VARCHAR(60) NOT NULL,
    matter_id INT NULL,
    details VARCHAR(255) NULL,
    ip_address VARCHAR(60) NULL,
    user_agent VARCHAR(255) NULL,
    created_at DATETIME NOT NULL,
    INDEX idx_action (action),
    INDEX idx_matter (matter_id),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

  foreach ($sql as $q) { $db->exec($q); }
  ok("Tables created/verified.");

  // seed roles
  $roles = ['admin','attorney','secretary','readonly'];
  $stmt = $db->prepare("INSERT IGNORE INTO roles (name) VALUES (?)");
  foreach ($roles as $r) $stmt->execute([$r]);
  ok("Roles seeded.");

  // seed admin if none
  $hasAdmin = (int)$db->query("SELECT COUNT(*) FROM users")->fetchColumn();
  if ($hasAdmin === 0) {
    $roleId = (int)$db->query("SELECT id FROM roles WHERE name='admin' LIMIT 1")->fetchColumn();
    $hash = password_hash('Admin123', PASSWORD_ARGON2ID);
    $stmt = $db->prepare("INSERT INTO users (role_id, full_name, email, password_hash, is_active, created_at, updated_at)
                          VALUES (?,?,?,?,1,NOW(),NOW())");
    $stmt->execute([$roleId, 'Admin User', 'admin@client.co.za', $hash]);
    ok("Default admin created: admin@client.co.za / Admin123");
  } else {
    ok("Users already exist. Skipping default admin seed.");
  }

  $db->commit();
  ok("Installation complete. DELETE install.php now.");
} catch (Throwable $e) {
  if ($db->inTransaction()) $db->rollBack();
  err($e->getMessage());
}

echo "</pre>";
