<?php
declare(strict_types=1);

function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function base_url(): string {
  $config = require __DIR__ . '/config.php';
  if (!empty($config['base_url'])) return rtrim($config['base_url'], '/');
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $script = $_SERVER['SCRIPT_NAME'] ?? '';
  // public/index.php -> /public
  $dir = rtrim(str_replace('/index.php','', $script), '/');
  return $scheme . '://' . $host . $dir;
}

function redirect(string $to): void {
  header('Location: ' . $to);
  exit;
}

function flash(string $key, ?string $value=null): ?string {
  if ($value !== null) {
    $_SESSION['_flash'][$key] = $value;
    return null;
  }
  $val = $_SESSION['_flash'][$key] ?? null;
  if (isset($_SESSION['_flash'][$key])) unset($_SESSION['_flash'][$key]);
  return $val;
}

function csrf_token(): string {
  $config = require __DIR__ . '/config.php';
  $key = $config['security']['csrf_key'] ?? 'csrf';
  if (empty($_SESSION['_csrf'])) {
    $_SESSION['_csrf'] = bin2hex(random_bytes(32));
  }
  return hash_hmac('sha256', $_SESSION['_csrf'], $key);
}

function csrf_check(?string $token): void {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $expected = csrf_token();
    if (!$token || !hash_equals($expected, $token)) {
      http_response_code(403);
      echo "CSRF validation failed.";
      exit;
    }
  }
}

function now(): string { return date('Y-m-d H:i:s'); }

function client_ip(): string {
  return $_SERVER['REMOTE_ADDR'] ?? 'unknown';
}

function user_agent(): string {
  return substr($_SERVER['HTTP_USER_AGENT'] ?? 'unknown', 0, 255);
}

function storage_path(): string {
  $config = require __DIR__ . '/config.php';
  return $config['storage_path'] ?? (__DIR__ . '/../storage');
}
