# LexForge (MVP) – Law Firm Matter & Document Management (cPanel/PHP/MySQL)

This is a lightweight, installable MVP you can upload to a cPanel subdomain.

## Features (MVP)
- Secure login (Argon2id password hashing)
- Roles (Admin, Attorney, Secretary, Read-only)
- Clients & Matters
- Matter staff assignment (non-admin users can only access assigned matters)
- Document folders per matter
- Upload documents with automatic **versioning**
- Secure download endpoint (permission-checked)
- Audit trail (upload, view, download, create/update)

## Requirements
- PHP 8.0+ (recommended 8.1/8.2)
- MySQL / MariaDB
- PDO MySQL enabled
- Apache with mod_rewrite (typical cPanel)

## Install
1. Create a MySQL database + user in cPanel and grant ALL privileges.
2. Upload this project to your domain/subdomain (e.g. `lexforge.yourdomain.co.za`).
3. Copy `app/config.sample.php` to `app/config.php` and fill DB credentials.
4. Visit: `https://yourdomain/install.php` and run the installer.
5. After success, **DELETE** `install.php`.

### Default login
- Email: `admin@client.co.za`
- Password: `Admin123`

## Storage
Uploads are stored in `/storage` (outside `/public`) and protected with an `.htaccess` deny rule.
For extra security, you can move `storage` outside web-root and update `app/config.php`.

## Notes
This MVP is intentionally simple and clean so it’s easy to customize, rebrand, and sell per-client.

